/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierSalvage
implements ICustomOutputRecipe<class_1263> {
    protected final class_2960 id;
    protected final class_1856 toolIngredient;
    protected final int maxToolSize;
    protected final ModifierId modifier;
    protected final int minLevel;
    protected final int maxLevel;
    @Nullable
    protected final SlotType.SlotCount slots;

    public ModifierSalvage(class_2960 id, class_1856 toolIngredient, int maxToolSize, ModifierId modifier, int minLevel, int maxLevel, @Nullable SlotType.SlotCount slots) {
        this.id = id;
        this.toolIngredient = toolIngredient;
        this.maxToolSize = maxToolSize;
        this.modifier = modifier;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.slots = slots;
        ModifierRecipeLookup.addSalvage(this);
    }

    public boolean matches(class_1799 stack, IToolStackView tool, int originalLevel) {
        return originalLevel >= this.minLevel && originalLevel <= this.maxLevel && this.toolIngredient.method_8093(stack);
    }

    public void updateTool(IToolStackView tool) {
        if (this.slots != null) {
            tool.getPersistentData().addSlots(this.slots.getType(), this.slots.getCount());
        }
    }

    public class_3956<?> method_17716() {
        return (class_3956)TinkerRecipeTypes.DATA.get();
    }

    @Deprecated
    public boolean method_8115(class_1263 inv, class_1937 level) {
        return false;
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.modifierSalvageSerializer.get();
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public int getMaxToolSize() {
        return this.maxToolSize;
    }

    public ModifierId getModifier() {
        return this.modifier;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ModifierSalvage> {
        public ModifierSalvage fromJson(class_2960 id, JsonObject json) {
            class_1856 toolIngredient = class_1856.method_52177((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"tools"));
            int maxToolSize = class_3518.method_15282((JsonObject)json, (String)"max_tool_size", (int)16);
            ModifierId modifier = ModifierId.getFromJson(json, "modifier");
            int minLevel = JsonUtils.getIntMin(json, "min_level", 1);
            int maxLevel = class_3518.method_15282((JsonObject)json, (String)"max_level", (int)Integer.MAX_VALUE);
            if (maxLevel < minLevel) {
                throw new JsonSyntaxException("Max level must be greater than or equal to min level");
            }
            SlotType.SlotCount slots = null;
            if (json.has("slots")) {
                slots = SlotType.SlotCount.fromJson(class_3518.method_15296((JsonObject)json, (String)"slots"));
            }
            return new ModifierSalvage(id, toolIngredient, maxToolSize, modifier, minLevel, maxLevel, slots);
        }

        @Nullable
        protected ModifierSalvage fromNetworkSafe(class_2960 id, class_2540 buffer) {
            class_1856 toolIngredient = class_1856.method_8086((class_2540)buffer);
            int maxToolSize = buffer.method_10816();
            ModifierId modifier = ModifierId.fromNetwork(buffer);
            int minLevel = buffer.method_10816();
            int maxLevel = buffer.method_10816();
            SlotType.SlotCount slots = SlotType.SlotCount.read(buffer);
            return new ModifierSalvage(id, toolIngredient, maxToolSize, modifier, minLevel, maxLevel, slots);
        }

        protected void toNetworkSafe(class_2540 buffer, ModifierSalvage recipe) {
            recipe.toolIngredient.method_8088(buffer);
            buffer.method_10804(recipe.getMaxToolSize());
            recipe.modifier.toNetwork(buffer);
            buffer.method_10804(recipe.minLevel);
            buffer.method_10804(recipe.maxLevel);
            SlotType.SlotCount.write(recipe.slots, buffer);
        }
    }
}

